/*

***************************************************************************
Macro_Scripts File
Author:   Attila Szabo
Macro_Scripts that implement some of the Help menu items

Revision History
    Aug 06, 2003 - aszabo - Created
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the hotkey movie macro in this file

	23 march 2006, Pierre-Felix Breton
		added a new "data exchange solutions" menu
		consolidated with the welcome screen

	30th June 2006, Pierre-Felix Breton
		Added a check for 64 bit in the welcome screen to load a different web page
		reduces the margins of the welcome screen
		
	April 2006, Chris Johnson
		Removed activeX controls, and added .NET controls.

-- MODIFY THIS AT YOUR OWN RISK
***************************************************************************

*/
macroScript Help_Web_Area_learning
buttontext:~HELP_WEB_AREA_LEARNING_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_AREA_LEARNING_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_AREA_LEARNING~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_LEARNING_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_OnlineSupport
buttontext:~HELP_WEB_ONLINESUPPORT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_ONLINESUPPORT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_SUPPORT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_ONLINE_SUPPORT_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Updates
buttontext:~HELP_WEB_UPDATES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_UPDATES_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_UPDATE~
	local strMsgTitle = "3ds Max"
	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_UPDATES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Training
buttontext:~HELP_WEB_TRAINING_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRAINING_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_TRAINING~
	local strMsgTitle = "3ds Max"
		
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRANING_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_ExchangeSolutions
buttontext:~HELP_WEB_EXCHANGESOLUTIONS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGESOLUTIONS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_MAX_EXCHANGE~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DATA_EXCHANGE_SOLUTIONS_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript HotkeyFlash 
category:~HELP_CATEGORY~ 
internalCategory:"Help"
tooltip:~HOTKEYFLASH_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_SHORTCUTS~
	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_SHORTCUTS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)
macroScript Help_Web_LearningPath
buttontext:~HELP_WEB_LEARNINGPATH_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_LEARNINGPATH_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_LEARNINGPATH~
	local strMsgTitle = "3ds Max"
        
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_LEARNING_PATH_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Web_TheArea
buttontext:~HELP_WEB_THEAREA_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_THEAREA_TOOLTIP~ 
(
	local fname = ~FNAME_AREA_AUTODESK_COM2~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_HowTo_Movies
buttontext:~HELP_HOWTO_MOVIES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_HOWTO_MOVIES_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_HOWTO~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_HOW_TO_MOVIES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Certified_Graphic_Cards
buttontext:~HELP_CERTIFIED_GRAPHIC_CARDS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CERTIFIED_GRAPHIC_CARDS_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_CERTHARDWARE~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CERTIFIED_HARDWARE_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Tutorials
buttontext:~HELP_TUTORIALS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_TUTORIALS_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_TUTORIALS~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TUTORIALS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)


macroScript Help_Vegetation
buttontext:~HELP_VEGETATION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_VEGETATION_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_SEEK_XFROG~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_VEGETATION_DOWNLOAD_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Student
buttontext:~HELP_STUDENT_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_STUDENT_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_EDCOMMUNITY~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_STUDENT_COMMUNITY_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_DefectSubmission
buttontext:~HELP_DEFECTSUBMISSION_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_DEFECTSUBMISSION_TOOLTIP~ 
(
	
	local fname = ~FNAME_AUTODESK_COM_3DSMAX_DEFECTSUBMIT~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_DEFECTSUBMISSION_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Feedback
buttontext:~HELP_WEB_FEEDBACK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FEEDBACK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FEEDBACK~
	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FEEDBACK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Facebook
buttontext:~HELP_WEB_FACEBOOK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_FACEBOOK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_FACEBOOK~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FACEBOOK_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Area_Forums
buttontext:~HELP_WEB_AREA_FORUMS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_AREA_FORUMS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_AREA_FORUMS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AREA_FORUMS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Ideas
buttontext:~HELP_WEB_IDEAS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_IDEAS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_IDEAS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_IDEAS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_3dsMax_Home
buttontext:~HELP_WEB_3DSMAX_HOME_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_3DSMAX_HOME_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_HOME~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_3DSMAX_HOME_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Web_Try_Other
buttontext:~HELP_WEB_TRY_OTHER_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_TRY_OTHER_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_TRY_OTHER~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_TRY_OTHER_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Exchange_Apps 
buttontext:~HELP_WEB_EXCHANGE_APPS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_WEB_EXCHANGE_APPS_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DSMAX_EXCHANGE_APPS~

	local strMsgTitle = "3ds Max"	
	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_EXCHANGE_APPS_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Free_Learning_Resources
buttontext:~HELP_FREE_LEARNING_RES_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FREE_LEARNING_RES_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FREE_LEARNING_RES~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FREE_LEARNING_RES_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_FBX_Review
buttontext:~HELP_FBXREVIEW_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_FBXREVIEW_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_FBXREVIEW~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_FBXREVIEW_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Pixlr
buttontext:~HELP_PIXLR_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_PIXLR_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_PIXLR~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_PIXLR_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_123dapp
buttontext:~HELP_123DAPP_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_123DAPP_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_123DAPP~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_123DAPP_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Character_Generator
buttontext:~HELP_CHARGEN_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_CHARGEN_TOOLTIP~ 
(
	
	local fname = ~AUTODESK_COM_3DSMAX_CHARGEN~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_CHARGEN_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_1min_essentials
buttontext:~HELP_1MIN_ESSENTIALS_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_1MIN_ESSENTIALS_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_1MIN_ESSENTIALS~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_1MIN_ESSENTIALS_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Join_Feedback_Community
buttontext:~HELP_JOIN_FEEDBACK_COMMUNITY_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_JOIN_FEEDBACK_COMMUNITY_TOOLTIP~ 
(
	local fname = ~FNAME_AUTODESK_COM_JOIN_FEEDBACK_COMMUNITY~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_JOIN_FEEDBACK_COMMUNITY_WEB_PAGE~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_3ds_Max_Developer_Help
buttontext:~HELP_3DS_MAX_DEVELOPER_HELP_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_3DS_MAX_DEVELOPER_HELP_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DS_MAX_DEVELOPER_HELP~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_3DS_MAX_DEVELOPER_HELP_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_3ds_Max_SDK_Download
buttontext:~HELP_3DS_MAX_SDK_DOWNLOAD_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_3DS_MAX_SDK_DOWNLOAD_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_3DS_MAX_SDK_DOWNLOAD~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_3DS_MAX_SDK_DOWNLOAD_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

macroScript Help_Autodesk_Developer_Network
buttontext:~HELP_AUTODESK_DEVELOPER_NETWORK_BUTTONTEXT~
category:~HELP_CATEGORY~ 
internalCategory:"Help" 
tooltip:~HELP_AUTODESK_DEVELOPER_NETWORK_TOOLTIP~ 
(
	local fname = ~AUTODESK_COM_AUTODESK_DEVELOPER_NETWORK~
	local strMsgTitle = "3ds Max"

	local strErrMsg = ~ERRMSG_UNABLE_DISPLAY_AUTODESK_DEVELOPER_NETWORK_WEB_PAGE~
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)
-- END OF FILE

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCinU/dpwYyYkyYKpCY0Zod/CTOmARu5ydV
-- zXZWJlpDBBkyIOFeUbJ7yw1790LAd5ZW9GdJBS9QT0zvi6IZA3qGAr4BZYwMesoh
-- UeufZI6CoLwlLZ9D86SggPoxSZlqyn7hdz4Bztgx7TXjOREJ0V36I4GoNned9fsh
-- 8dLkzF38Ae1Tvci6Clz+K+eFwN3yhmiucl+3nw63DwUhdC9HBefvbcH74PPVYUwz
-- FHuPHnr+lSXnJazDmK/nS4cdzDWJkmu6Y91DoyQgEEcZ2I+7l2W5YkE2AF4l45r7
-- 9btlveDfQdeBLMxpWtgq5+IeY7klFDyQcDE9UUygTn8LeDI6EadB
-- -----END-SIGNATURE-----